/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsJarContentsCache;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public class AcsLookasideJarsMgr {
    private List<URL> m_lookasideJars = null;
    private boolean m_isLookasideReady;
    private File m_dir;
    private final File m_lookasideDirFile = new File(AcsProperties.getProperties().getTempDir().getPath() + File.separator + "acs.jar_cache" + String.format("%x", new String(AcsJarContentsCache.getThisProcessUniqueSeed()).hashCode()) + String.format("%x", System.getProperty("user.name").hashCode()));
    private int m_fileidCount = 0;
    private long[] m_storedHash;
    public static final String JAR_CACHE_DIR_PREFIX = "acs.jar_cache";

    public AcsLookasideJarsMgr() {
        boolean bl = false;
        File file = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_lookasideDirFile), "UTF-8"));){
            String string = bufferedReader.readLine();
            File file2 = new File(string);
            if (file2.isDirectory()) {
                String string2;
                file = file2;
                this.m_fileidCount = Integer.parseInt(bufferedReader.readLine());
                this.m_storedHash = new long[this.m_fileidCount];
                int n = 1;
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.m_storedHash[n++] = Long.parseLong(string2);
                }
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            AcsStartupUtil.addDelayedLog(fileNotFoundException.toString());
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        if ((null == file || 0 == this.m_fileidCount) && AcsLookasideJarsMgr.isUsed()) {
            try {
                file = AcsLookasideJarsMgr.getNewJarLookasideDir();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.m_dir = file;
        this.m_isLookasideReady = bl;
    }

    public synchronized void load(List<URL> list) throws IOException {
        if (null != this.m_lookasideJars) {
            return;
        }
        this.m_lookasideJars = new LinkedList<URL>();
        if (!this.m_isLookasideReady) {
            Object object;
            int n = 1;
            for (URL serializable : list) {
                if (AcsLaunchPad.isJarFileHiddenFromView(serializable.toString())) continue;
                File throwable = new File(this.m_dir.getAbsolutePath() + File.separator + n++ + ".dat").getAbsoluteFile();
                try {
                    SwingUtilities.invokeAndWait(() -> AcsLaunchPad.updateProgressBar());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    AcsStartupUtil.addDelayedLog(exception);
                }
                throwable.getParentFile().mkdirs();
                Throwable throwable2 = null;
                try (InputStream inputStream = serializable.openConnection().getInputStream();){
                    object = new BufferedOutputStream(new FileOutputStream(throwable), 524288);
                    Throwable throwable3 = null;
                    try {
                        int n2;
                        byte[] byArray = new byte[65536];
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            ((OutputStream)object).write(byArray, 0, n2);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (object != null) {
                            if (throwable3 != null) {
                                try {
                                    ((OutputStream)object).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                            } else {
                                ((OutputStream)object).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    Throwable throwable7 = throwable6;
                    throw throwable6;
                }
                this.m_lookasideJars.add(throwable.toURI().toURL());
            }
            AcsStartupUtil.addDelayedLog("writing lookaside pointer file: " + this.m_lookasideDirFile);
            try {
                Throwable throwable = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_lookasideDirFile), "UTF-8"));){
                    bufferedWriter.write(this.m_dir.getAbsolutePath());
                    bufferedWriter.write("\n" + n);
                    this.m_fileidCount = n;
                    bufferedWriter.newLine();
                    int throwable8 = 1;
                    for (URL uRL : list) {
                        if (AcsLaunchPad.isJarFileHiddenFromView(uRL.toString())) continue;
                        object = new File(this.m_dir.getAbsolutePath() + File.separator + throwable8++ + ".dat").getAbsoluteFile();
                        long l = this.specialHash((File)object);
                        bufferedWriter.write(Long.toString(l) + "\n");
                    }
                }
                catch (Throwable throwable9) {
                    Throwable throwable10 = throwable9;
                    throw throwable9;
                }
            }
            catch (Exception exception) {
                AcsStartupUtil.addDelayedLog(exception);
            }
        } else {
            for (int i = 1; i < this.m_fileidCount; ++i) {
                File file = new File(this.m_dir.getAbsolutePath() + File.separator + i + ".dat").getAbsoluteFile();
                if (!file.exists() || this.specialHash(file) != this.m_storedHash[i]) {
                    this.m_lookasideJars = null;
                    AcsStartupUtil.addDelayedLog("***Missing jarcache: " + file.getAbsolutePath() + " getting new lookaside dir");
                    this.m_dir = AcsLookasideJarsMgr.getNewJarLookasideDir();
                    this.m_isLookasideReady = false;
                    this.load(list.isEmpty() ? AcsLaunchPad.getNestedJars() : list);
                    break;
                }
                this.m_lookasideJars.add(file.toURI().toURL());
            }
        }
    }

    private long specialHash(File file) {
        long l = Long.MAX_VALUE;
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = basicFileAttributes.lastModifiedTime();
            FileTime fileTime2 = basicFileAttributes.creationTime();
            l = (long)(file.hashCode() << 32) + file.length() ^ fileTime.toMillis() ^ fileTime2.toMillis();
        }
        catch (IOException iOException) {
            AcsStartupUtil.addDelayedLog(iOException.toString());
        }
        return l;
    }

    public List<URL> getLookasideJars() {
        return this.m_lookasideJars;
    }

    private static File getNewJarLookasideDir() throws IOException {
        File file = File.createTempFile(JAR_CACHE_DIR_PREFIX, ".dir", AcsProperties.getProperties().getTempDir());
        file.delete();
        file.mkdirs();
        if (file.isDirectory() && file.exists()) {
            return file;
        }
        throw new IOException("Unable to get Jar lookaside directory");
    }

    public static final boolean isUsed() {
        return AcsProperties.getProperties().isLocalJarCaching() && AcsLaunchLocator.getLocator().isInsideJarOrZip();
    }

    public boolean isPrimeNeeded() {
        return !this.m_isLookasideReady && AcsLookasideJarsMgr.isUsed() && null == this.m_lookasideJars;
    }

    public void getPlugins(List<String> list) {
        if (null == this.m_lookasideJars) {
            throw new RuntimeException();
        }
        try {
            for (URL uRL : this.m_lookasideJars) {
                JarFile jarFile = new JarFile(new File(uRL.toURI()));
                Throwable throwable = null;
                try {
                    String string;
                    Attributes attributes;
                    Manifest manifest = jarFile.getManifest();
                    if (null == manifest || null == (attributes = manifest.getMainAttributes()) || null == (string = attributes.getValue("Acs-Plugins"))) continue;
                    for (String string2 : string.split("\\s+")) {
                        list.add(string2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }
}

