/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsDirectoryNames;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
class AcsJarContentsCache
implements Serializable {
    private static volatile transient AcsJarContentsCache m_singleton;
    private static byte[] m_thisProcessUniqueSeed;
    private static final long serialVersionUID = 5L;
    protected static final String JARLOOKASIDE_DONE_FILE = "done.done";
    private volatile transient boolean m_isWriteNeeded = false;
    private final Map<String, ArrayList<String>> m_jarEntries = new ConcurrentHashMap<String, ArrayList<String>>();
    private final Map<String, String> m_manifests = new ConcurrentHashMap<String, String>();
    private byte[] m_uniqueSeed;
    private volatile boolean m_isDevalidated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AcsJarContentsCache getCache() {
        if (null != m_singleton) {
            return m_singleton;
        }
        File file = new File(AcsJarContentsCache.getSavedFileName());
        if (!file.exists()) {
            m_singleton = new AcsJarContentsCache();
            AcsJarContentsCache.m_singleton.m_uniqueSeed = AcsJarContentsCache.getThisProcessUniqueSeed();
            return m_singleton;
        }
        boolean bl = false;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
            m_singleton = (AcsJarContentsCache)objectInputStream.readObject();
            AcsJarContentsCache.m_singleton.m_isWriteNeeded = false;
            if (!Arrays.equals(AcsJarContentsCache.m_singleton.m_uniqueSeed, AcsJarContentsCache.getThisProcessUniqueSeed())) {
                AcsStartupUtil.addDelayedLog("unique seeds do not match.. not using cache on disk");
                m_singleton = new AcsJarContentsCache();
            }
            AcsStartupUtil.addDelayedLog("Jar cache loaded...");
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        finally {
            if (bl) {
                file.delete();
                m_singleton = new AcsJarContentsCache();
            }
        }
        AcsJarContentsCache.m_singleton.m_uniqueSeed = AcsJarContentsCache.getThisProcessUniqueSeed();
        return m_singleton;
    }

    private static String getSavedFileName() {
        return AcsDirectoryNames.JARCACHE + File.separator + ".cache";
    }

    static synchronized byte[] getThisProcessUniqueSeed() {
        Object object;
        if (null != m_thisProcessUniqueSeed) {
            return (byte[])m_thisProcessUniqueSeed.clone();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object2;
            Object object3;
            Object object4;
            try {
                object = new File(AcsLaunchLocator.getLocator().getUrl().toURI());
                byteArrayOutputStream.write(("\n" + new Date(((File)object).lastModified())).getBytes());
                byteArrayOutputStream.write(("\n" + ((File)object).length() + "\n").getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = AcsJarContentsCache.class.getClassLoader().getResourceAsStream("acsmain.jar");
                Throwable object52 = null;
                try {
                    object4 = null == object ? null : new ZipInputStream((InputStream)object);
                    object3 = null;
                    try {
                        object2 = null;
                        while (null != object4 && null != (object2 = ((ZipInputStream)object4).getNextEntry())) {
                            byteArrayOutputStream.write(("" + new Date(((ZipEntry)object2).getTime()) + "\n").getBytes());
                            byteArrayOutputStream.write(("" + new Date(((ZipEntry)object2).getCrc()) + "\n").getBytes());
                        }
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object4 != null) {
                            if (object3 != null) {
                                try {
                                    ((ZipInputStream)object4).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object3).addSuppressed(throwable);
                                }
                            } else {
                                ((ZipInputStream)object4).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (object52 != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                object52.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (Map.Entry entry : AcsProperties.getProperties().getPropertiesList().entrySet()) {
                object4 = "" + entry.getKey() + "=" + entry.getValue() + "\n";
                byteArrayOutputStream.write(((String)object4).getBytes());
            }
            object = AcsJarContentsCache.class.getClassLoader();
            ClassLoader classLoader = ((ClassLoader)object).getParent();
            object4 = null == classLoader ? object : classLoader;
            AcsStartupUtil.addDelayedLog("JarCache looking up manifest using classloader: " + object4);
            object3 = ((ClassLoader)object4).getResourceAsStream("/jarcacheinfo/acsjarcacheinfo.txt");
            if (null != object3) {
                object2 = new byte[1024];
                int n = 0;
                while (-1 != (n = ((InputStream)object3).read((byte[])object2))) {
                    byteArrayOutputStream.write((byte[])object2, 0, n);
                }
                byteArrayOutputStream.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        m_thisProcessUniqueSeed = byteArrayOutputStream.toByteArray();
        object = new String(m_thisProcessUniqueSeed);
        AcsStartupUtil.addDelayedLog("Unique seed:" + (String)object);
        return (byte[])m_thisProcessUniqueSeed.clone();
    }

    protected AcsJarContentsCache() {
    }

    public AcsJarContentsCache clearJarEntries(URL uRL) {
        this.getOrCreateJarEntries(uRL).clear();
        this.m_isWriteNeeded = true;
        return this;
    }

    public List<String> getJarEntriesForJar(URL uRL) {
        List list = this.m_jarEntries.get(uRL.toString());
        return list;
    }

    public String getManifestOrNull(URL uRL) {
        return this.m_manifests.get(uRL.toString());
    }

    public List<String> getOrCreateJarEntries(URL uRL) {
        ArrayList<String> arrayList = this.m_jarEntries.get(uRL.toString());
        if (null != arrayList) {
            return arrayList;
        }
        arrayList = new ArrayList();
        this.m_isWriteNeeded = true;
        this.m_jarEntries.put(uRL.toString(), arrayList);
        return arrayList;
    }

    public AcsJarContentsCache putJarEntry(URL uRL, String string) {
        this.m_isWriteNeeded = true;
        this.getOrCreateJarEntries(uRL).add(string);
        return this;
    }

    public AcsJarContentsCache putManifest(URL uRL, String string) {
        this.m_isWriteNeeded = true;
        this.m_manifests.put(uRL.toString(), string);
        return this;
    }

    /*
     * Exception decompiling
     */
    public synchronized AcsJarContentsCache write() throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void devalidate() {
        this.m_isDevalidated = true;
        new File(AcsJarContentsCache.getSavedFileName()).delete();
    }

    static {
        m_thisProcessUniqueSeed = null;
    }
}

