/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.File;
import java.util.Objects;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public final class AcsDirectoryNames {
    public static final String DUMPS;
    public static final String LOGS;
    public static final String SERVICE_DIR;
    public static final String JARCACHE;
    public static final String PWCACHES;
    public static final String USER_SETTINGS;
    public static final String OPCON_SESSIONS;
    public static final String HMC;
    public static final String EMULATOR;
    public static final String HELP;
    public static final String LM;
    public static final String LICENSE;
    public static final String CONFIGURATION_ROOT;
    public static final String SPOOLED_FILES;
    public static String DESKTOP;
    public static final String DATAXFER;
    public static final String DB2;
    public static final String RUN_SQL_SCRIPTS;
    public static final String JDBC_CONFIGURATIONS;
    public static final String SQL_EXAMPLES;
    public static final String RSS_PROJECTS;
    public static final String DESKTOP_LOCATION = "com.ibm.iaccess.DesktopLocation";

    private AcsDirectoryNames() {
    }

    public static boolean isNullOrEmptyString(String string) {
        return null == string || string.trim().isEmpty();
    }

    public static boolean isValidNonEmptyString(String string) {
        return !AcsDirectoryNames.isNullOrEmptyString(string);
    }

    static {
        File file;
        DUMPS = AcsProperties.getProperties().getMyDocumentsSubDir("Dumps");
        LOGS = AcsProperties.getProperties().getMyDocumentsSubDir("Logs");
        SERVICE_DIR = AcsProperties.getProperties().getServiceDirectory().getAbsolutePath();
        JARCACHE = AcsProperties.getJarCacheDirectory();
        PWCACHES = AcsProperties.getProperties().getMyDocumentsSubDir("Private") + File.separator + System.getProperty("user.name", "<unknown>");
        USER_SETTINGS = AcsProperties.getProperties().getMyDocumentsSubDir("Settings");
        OPCON_SESSIONS = AcsProperties.getProperties().getMyDocumentsSubDir("OpCon") + File.separator + "Sessions";
        HMC = OPCON_SESSIONS + File.separator + "hmc";
        EMULATOR = AcsProperties.getProperties().getMyDocumentsSubDir("Emulator");
        HELP = AcsProperties.getProperties().getHelpDirectory();
        LM = AcsProperties.getProperties().getMyDocumentsSubDir("LM");
        LICENSE = AcsProperties.getProperties().getMyDocumentsSubDir("License");
        CONFIGURATION_ROOT = AcsProperties.getProperties().getProductDirectory().getAbsolutePath();
        SPOOLED_FILES = AcsProperties.getProperties().getMyDocumentsSubDir("Splf");
        DATAXFER = AcsProperties.getProperties().getMyDocumentsSubDir("DataTransfer");
        DB2 = AcsProperties.getProperties().getMyDocumentsSubDir("DB2");
        RUN_SQL_SCRIPTS = AcsProperties.getProperties().getMyDocumentsSubDir("RunSQLScripts");
        JDBC_CONFIGURATIONS = RUN_SQL_SCRIPTS + File.separator + "JDBC";
        SQL_EXAMPLES = RUN_SQL_SCRIPTS + File.separator + "Examples";
        RSS_PROJECTS = RUN_SQL_SCRIPTS + File.separator + "Projects";
        String string = AcsProperties.getProperties().getProperty(DESKTOP_LOCATION);
        if (AcsDirectoryNames.isValidNonEmptyString(string) && (file = new File(string)).isDirectory() && file.canWrite()) {
            DESKTOP = string;
        }
        if (Objects.isNull(DESKTOP)) {
            DESKTOP = System.getProperty("user.home") + File.separator + "Desktop";
        }
    }
}

